<?php
/**
 * Provisioning provider for most of the snom phones (3xx, 7xx, 8xx, snommp, snomMxxx, etc.)
 */

/*
 * Older fw support
 * Some phones used to fetch /snomM300/snomM300-{mac}.htm
 * It appears that the new firmwares ask for /snomM300-{mac}.htm
 * Let's support both locations by stripping away the directory
 */
$path = $PATH;
if (preg_match('~^/snom([0-9a-zA-Z]+)(/snom\1.*)$~i', $path, $matches)) {
	$path = $matches[2];
}

/**
 * M300 firmware
 * fw v0324 asks for /snomM300/snomM300-firmware.htm
 * fw v0355 asks for /snomM300-firmware.htm
 */
$matches = array();
if (preg_match('~^/snom(M[0-9]{3})-firmware.htm~i', $path, $matches)) {
	sendTemplate('snomm300_firmware');
}

/**
 * FILENAME MATCHING
 */
$matches = array();
if (preg_match('~^/snom([0-9a-zA-Z]+)-([0-9a-fA-F]{12})\.htm~i', $path, $matches)) {
	$model = 'snom' . strtr(strtolower($matches[1]), array('-' => '', '_' => ''));

	/* if the model starts with a d, remove it - new snom models D765 ask for d765 */
	$model = preg_replace('/^snom[dD](.*)$/', 'snom$1', $model);

	if (!isset($PHONE_TYPES[$model])) {
		$model = 'snom_generic';
	}
	$mac = normalizeMac($matches[2]);

	/* create new prov. phone */
	associatePhone($mac, $model);

	if (preg_match('/^snomm[0-9].*/', $model)) {
		sendTemplate('snomm300');
	}
	else {
		// must be called after associatePhone()
		$firmwares = phoneFirmwares('firmware', true);
		$firmware_status = $firmwares ? "/prov/$MODULE_ID/firmware/$firmwares[0].xml" : '';

		sendTemplate('snom3xx');
	}
}
