<?php
/**
 * Firmware status
 */
$matches = array();
if (preg_match("~^/prov/$MODULE_ID/firmware/([^/]+)\\.xml$~i", $PATH, $matches)) {
	if (haveFirmware($matches[1])) {
		$md5 = trim(file_get_contents(getFirmwareFile($matches[1], 'firmware.md5')));
		$firmware_path = "/prov/$MODULE_ID/firmware/$matches[1].bin-$md5";

		switch ($matches[1]) {
			case 'fw_m9':
				sendTemplate('snomm9_firmware');
				break;
			default:
				sendTemplate('snom3xx_firmware');
		}
	}
	sendNotFound();
}

/**
 * Firmwares
 */
$matches = array();
if (preg_match("~^/prov/$MODULE_ID/firmware/([^/]+)\\.bin-[^/]+$~i", $PATH, $matches)) {
	if (haveFirmware($matches[1])) {
		sendFile(getFirmwareFile($matches[1], 'firmware.bin'));
	}
	sendNotFound();
}