<?php
$ret = '';
$data = dialplanSimplifyOnedigit($DIALPLAN_DATA);

foreach ($data as $item) {
	list($prefix, $len) = $item;

	$prefix = str_replace('*', '\*', $prefix);

	if (($len == -1 ) && (strlen($prefix) <= 0)) {
		/* empty prefix overrides everything */
		$ret = '';
		break;
	}

	switch ($len) {
		case -1: /* skip prefixes, they are not needed for snom phones */
			continue;
		case 0:
			if (strlen($ret) > 0) {
				$ret .= "|";
			}
			$ret .= '^(' . $prefix . ')$';
			break;
		default:
			if (strlen($ret) > 0) {
				$ret .= "|";
			}
			$ret .= '^(' . $prefix . '[0-9\*#]{' . $len . '})$';
	}
}

if (!empty($ret)) {
	echo '!' . $ret . '!sip:\1@\d!d';
}
else {
	echo '!^sip:(.+)$|^(.+)$!sip:\1@\d!'; /* no final 'd' (dial now) */
}
