<?xml version="1.0" encoding="UTF-8"?>
<settings>
	<global>
		<!-- Timezone configuration - for possible values refer to http://downloads.snom.net/documentation/Provisioning_Guide_M700_M300.pdf -->
		<timezone>GBR-0</timezone>
		<!-- <country_region_id></country_region_id> -->
		<timezone_by_country_region>on</timezone_by_country_region>
		<dst_by_country_region>on</dst_by_country_region>

		<!-- Tone configuration - possible values: GER, FRA, ITA, NLD, SWE, ESP, DNK, SWI, AUT, GBR, NOR, USAAUS, CHN, IND, JPNMEX, NZL -->
		<tone_scheme>GBR</tone_scheme>


		<http_user>admin</http_user>
		<http_pass>{$ADMIN_PASSWORD}</http_pass>
		<ntp_server>{$NTP_PRIMARY}</ntp_server>
		<ntp_refresh_timer>{$NTP_REFRESH}</ntp_refresh_timer>
		<phone_name>{transliterate($PHONE_LABEL)}</phone_name>

		@ if ($DIRECTORY_ENABLED) {
		<phonebook_server_location>1</phonebook_server_location>
		<ldap_name_attributes>cn</ldap_name_attributes>
		<ldap_search_filter>{str_replace('%', '%*', $DIRECTORY_NAME_FILTER)}</ldap_search_filter>
		<ldap_server>{$DIRECTORY_HOSTNAME}</ldap_server>
		<ldap_port>{$DIRECTORY_PORT}</ldap_port>
		<ldap_base>{$DIRECTORY_SEARCH_BASE}</ldap_base>
		<ldap_username>{$DIRECTORY_USERNAME}</ldap_username>
		<ldap_password>{$DIRECTORY_PASSWORD}</ldap_password>
		<ldap_number_attributes>{$DIRECTORY_NUMBER_ATTRIBUTES}</ldap_number_attributes>
		@ }

	</global>
	<server>
		<srv_sip_server_alias idx="1">UDP</srv_sip_server_alias>
		<user_srtp idx="1">off</user_srtp>
		<user_host idx="1">{$OPERATOR_IP}</user_host>
		<user_outbound idx="1">{$OPERATOR_IP}</user_outbound>
		<srv_srtp_auth idx="1">off</srv_srtp_auth>
		<srv_sip_transport idx="1">udp</srv_sip_transport>
		<user_auth_tag idx="1">off</user_auth_tag>

		<srv_sip_server_alias idx="2">TLS</srv_sip_server_alias>
		<user_srtp idx="2">on</user_srtp>
		<user_host idx="2">{$OPERATOR_IP}</user_host>
		<user_outbound idx="2">{$OPERATOR_IP}</user_outbound>
		<srv_srtp_auth idx="2">on</srv_srtp_auth>
		<srv_sip_transport idx="2">tls</srv_sip_transport>
		<user_auth_tag idx="2">off</user_auth_tag>
	</server>
	<extension>

		@ for ($i = 1; $i <= $MAX_LINES; $i++) {
		@ if (isset($LINES[$i - 1])) {
		@ $data = $LINES[$i - 1];
		@ $displayName = ($data['USER_FULLNAME'] ? $data['USER_FULLNAME'] : '');

		<user_name idx="{$i}">{$data['SIP_USERNAME']}</user_name>
		<user_realname idx="{$i}">{transliterate($displayName)}</user_realname>
		<user_pname idx="{$i}">{$data['SIP_USERNAME']}</user_pname>
		<user_pass idx="{$i}">{$data['SIP_PASSWORD']}</user_pass>
		<user_active idx="{$i}">on</user_active>
		<subscr_sip_line_name idx="{$i}">{$data['SIP_USERNAME']}</subscr_sip_line_name>
		@ if ($data['SECURE']) {
		<subscr_sip_ua_data_server_id idx="{$i}">2</subscr_sip_ua_data_server_id>
		@ } else {
		<subscr_sip_ua_data_server_id idx="{$i}">1</subscr_sip_ua_data_server_id>
		@ }
		<user_mailbox idx="{$i}">voicemail</user_mailbox>
		<user_mailnumber idx="{$i}">{$VOICEMAIL_EXT}</user_mailnumber>
		@ } else {
		<user_name idx="{$i}"></user_name>
		<user_realname idx="{$i}"></user_realname>
		<user_pname idx="{$i}"></user_pname>
		<user_pass idx="{$i}"></user_pass>
		<user_active idx="{$i}">off</user_active>
		@ }
		@ }
	</extension>
</settings>
